package ru.yandex.qe.mail.meetings.ws.validation;

import ru.yandex.qe.mail.meetings.utils.FormConverters;

/**
 * @author Sergey Galyamichev
 */
public class BookingValidator implements Validator {
    @Override
    public ValidationResult validate(ValidationRequest request) {
        String type = request.getAnswer("meeting_type");
        // event series do not have ttl
        if ("Разовой".equals(type) && !FormConverters.convertYesNo(request.getAnswer("book_now"))) {
            return IntValidator.of("ttl_booking").validate(request);
        }
        return ValidationResult.success();
    }
}
