package ru.yandex.qe.mail.meetings.ws.validation;

import javax.annotation.Nonnull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.mail.meetings.services.calendar.CalendarWeb;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.ws.EventResourceDescriptor;


public class CalendarUrlValidator implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarUrlValidator.class);

    private final CalendarWeb calendarWeb;
    private final String field;
    private final StaffClient staffClient;

    public static CalendarUrlValidator with(@Nonnull CalendarWeb calendarWeb, @Nonnull StaffClient staffClient, @Nonnull String field) {
        return new CalendarUrlValidator(calendarWeb, staffClient, field);
    }

    public CalendarUrlValidator(@Nonnull CalendarWeb calendarWeb, @Nonnull StaffClient staffClient, @Nonnull String field) {
        this.calendarWeb = calendarWeb;
        this.staffClient = staffClient;
        this.field = field;
    }

    @Override
    public ValidationResult validate(ValidationRequest validationRequest) {
        String url = validationRequest.getAnswer(field);
        try {
            EventResourceDescriptor.fromRequest(calendarWeb, staffClient, null, url);
        } catch (Exception e) {
            LOG.error("url validation error", e);
            return ValidationResult.error(field);
        }
        return ValidationResult.success();
    }
}
