package ru.yandex.qe.mail.meetings.ws.validation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.qe.mail.meetings.api.resource.dto.MergeEventRequest;
import ru.yandex.qe.mail.meetings.cron.actions.MergeResource;
import ru.yandex.qe.mail.meetings.services.calendar.CalendarWeb;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;

/**
 * @author Sergey Galyamichev
 */
public class MergeEventValidator implements Validator {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
    private final CalendarWeb calendarWeb;
    private final StaffClient staffClient;

    public MergeEventValidator(CalendarWeb calendarWeb, StaffClient staffClient) {
        this.calendarWeb = calendarWeb;
        this.staffClient = staffClient;
    }

    @Override
    public ValidationResult validate(ValidationRequest request) {
        try {
            MergeEventRequest mergeEventRequest = MAPPER.convertValue(request.toQuestionsMap(), MergeEventRequest.class);
            MergeResource resource = new MergeResource(calendarWeb, staffClient, null);
            return resource.validate(mergeEventRequest);
        } catch (Exception e) {
            return ValidationResult.error("", e);
        }
    }
}
