package ru.yandex.qe.mail.meetings.ws.validation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.qe.mail.meetings.api.resource.dto.AddResourceRequest;
import ru.yandex.qe.mail.meetings.services.calendar.CalendarWeb;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.ws.SearchAction;

/**
 * @author Sergey Galyamichev
 */
public class SearchResourceValidator implements Validator {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private final CalendarWeb calendarWeb;
    private final StaffClient staffClient;

    public SearchResourceValidator(CalendarWeb calendarWeb, StaffClient staffClient) {
        this.calendarWeb = calendarWeb;
        this.staffClient = staffClient;
    }

    @Override
    public ValidationResult validate(ValidationRequest request) {
        try {
            AddResourceRequest addRequest = MAPPER.convertValue(request.toQuestionsMap(), AddResourceRequest.class);
            SearchAction search = new SearchAction(calendarWeb, staffClient);
            return search.validate(addRequest);
        } catch (Exception e) {
            return ValidationResult.error("", e);
        }
    }
}
