package ru.yandex.qe.mail.meetings.ws.validation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.qe.mail.meetings.api.resource.dto.SwapResourceRequest;
import ru.yandex.qe.mail.meetings.cron.actions.ResourceSwapper;
import ru.yandex.qe.mail.meetings.services.calendar.CalendarWeb;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;

/**
 * @author Sergey Galyamichev
 */
public class SwapRequestValidator implements Validator {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private CalendarWeb calendarWeb;
    private StaffClient staffClient;

    public SwapRequestValidator(CalendarWeb calendarWeb, StaffClient staffClient) {
        this.calendarWeb = calendarWeb;
        this.staffClient = staffClient;
    }

    @Override
    public ValidationResult validate(ValidationRequest request) {
        try {
            SwapResourceRequest swapResourceRequest = MAPPER.convertValue(request.toQuestionsMap(), SwapResourceRequest.class);
            ResourceSwapper swapper = new ResourceSwapper(calendarWeb, staffClient);
            return swapper.validate(swapResourceRequest);
        } catch (Exception e) {
            return ValidationResult.error("targetCalendarUrl", e);
        }
    }
}
