<#import "common.ftl" as c/>
<#setting time_zone="Europe/Moscow">
<@c.template name>
    <br>
    <div>
        Вы собираетесь отсутствовать в период:
        <ul>
            <#list gaps as gap>
                <li>
                    <b>c ${gap.dateFrom?date} до ${gap.dateToRounded?date}</b>
                </li>
            </#list>
        </ul>
        Возможно, вы пропустите встречи. Если вы действительно хотите пропустить встречи, откажитесь от них или отмените их. Если хотите оставить встречи в календаре, ничего не делайте.
    </div>
    <br>
    <#if declines??>
        <div>
            <span>
                <b>Встречи, где вы приглашенный</b>
            </span>
            <ul>
                <#list declines as action>
                    <li>
                        <a href="https://calendar.yandex-team.ru/event?event_date=${action.start?date?iso_local}&event_id=${action.eventId}">${action.event.name}</a> ${action.start?datetime} — <a href="${host}/api/actions/execute?actionId=${action.actionId}" style="font-weight: bold"><b>Не пойду</b></a>
                    </li>
                </#list>
            </ul>
            <a href="${host}/api/actions/executeGroup?groupId=${declinesGroupId}"><b>Не пойду на все</b></a>
        </div>
        <br />
    </#if>
    <#if removes??>
        <div>
            <span>
                <b>Встречи, где вы организатор</b>
            </span>
            <ul>
                <#list removes as action>
                    <li>
                        <a href="https://calendar.yandex-team.ru/event?event_date=${action.start?date?iso_local}&event_id=${action.eventId}">${action.event.name}</a> ${action.start?datetime}. <a href="${host}/api/actions/execute?actionId=${action.actionId}" style="font-weight: bold"><b>Отменить</b></a>
                    </li>
                </#list>
            </ul>
            <a href="${host}/api/actions/executeGroup?groupId=${removesGroupId}"><b>Отменить все</b></a>
        </div>
        <br />
    </#if>
    <#if notifications??>
        <div>
            <span>
                <b>Пожалуйста, убедитесь, что следующие встречи состоятся в Ваше отсутствие:</b>
            </span>
            <ul>
                <#list notifications as action>
                    <li>
                        <a href="https://calendar.yandex-team.ru/event?event_date=${action.start?date?iso_local}&event_id=${action.eventId}">${action.event.name}</a> ${action.start?datetime}.
                    </li>
                </#list>
            </ul>
        </div>
        <br />
    </#if>
    <div>
        <i>Если у вас есть вопросы или пожелания, напишите на рассылку <a href="mailto:meetings-report@yandex-team.ru">meetings-report@yandex-team.ru</a></i>
    </div>
    <br />
</@c.template>
