import os

import yaml

from library.python import resource
from mail.devpack.lib import helpers
from mail.devpack.lib.components.base import DogAppComponent, FakeRootComponent
from mail.devpack.ctl.lib.main import wrap_main
from mail.webmail_config.lib.make_config import make_config


class MBody(DogAppComponent):
    NAME = 'mbody'
    DEPS = []

    def __init__(self, env, components):
        super(MBody, self).__init__(env, components, custom_path='message_body')

    def _init_root(self):
        self._generate_config('development')

        with open('mbody.properties-devpack', 'w') as f:
            f.write('''
mbody.host=http://localhost
mbody.port={mbody_port}
                '''.format(mbody_port=self.webserver_port()))

    def _generate_config(self, env):
        base = resource.find('mbody/config.yml')
        service_yaml = yaml.safe_load(resource.find('mbody/service.yaml'))
        common_yaml = yaml.safe_load(resource.find('webmail_config/common.yaml'))
        cfg = make_config(env, base, service_yaml, common_yaml, silent=True)
        config = self.yhttp.format_config(cfg)
        helpers.write2file(config, os.path.join(self.config_path, 'config.yml'))

    def init_root(self):
        self.yhttp.logger.info("init root!")
        self.yhttp.init_root()

        helpers.write2file(resource.find('mbody/tvm_secret'), os.path.join(self.secrets_path, 'tvm_secret'))
        helpers.write2file(resource.find('mail_getter/vdirect_keys'), os.path.join(self.secrets_path, 'vdirect_keys'))
        helpers.write2file(resource.find('mbody/mime-types.xml'), os.path.join(self.config_path, 'mime-types.xml'))
        helpers.write2file(resource.find('mbody/mime.types'), os.path.join(self.config_path, 'mime.types'))
        helpers.write2file(resource.find('mbody/libmagic.issues'), os.path.join(self.config_path, 'libmagic.issues'))
        helpers.write2file(resource.find('mbody/factextract.conf'), os.path.join(self.config_path, 'factextract.conf'))
        helpers.write2file(resource.find('mbody/ext-hostings-video.xml'), os.path.join(self.config_path, 'ext-hostings-video.xml'))
        helpers.write2file(resource.find('mbody/phishing.regexp'), os.path.join(self.config_path, 'phishing.regexp'))

        helpers.write2file(resource.find('recognizer/dict.dict'), os.path.join(self.resources_path, 'dict.dict'))
        helpers.write2file(resource.find('recognizer/queryrec.dict'), os.path.join(self.resources_path, 'queryrec.dict'))
        helpers.write2file(resource.find('recognizer/queryrec.weights'), os.path.join(self.resources_path, 'queryrec.weights'))

        helpers.write2file(resource.find('attach_sid_aes_keys.json'), os.path.join(self.secrets_path, 'attach_sid_aes_keys.json'))
        helpers.write2file(resource.find('attach_sid_hmac_keys.json'), os.path.join(self.secrets_path, 'attach_sid_hmac_keys.json'))

        helpers.write2file(resource.find('macs_pg/query.conf'), os.path.join(self.config_path, 'query.conf'))

        self._init_root()


class MBodyTesting(MBody):
    NAME = 'mbody_testing'
    DEPS = []

    def __init__(self, env, components):
        super(MBodyTesting, self).__init__(env, components)

    def _init_root(self):
        devpack = self.yhttp.format_config(resource.find('mbody/testing.yml'))
        self.yhttp.logger.info(devpack)
        self.yhttp.logger.info(os.path.join(self.config_path, 'config-devpack.yml'))
        helpers.write2file(devpack, os.path.join(self.config_path, 'config-devpack.yml'))

        self._generate_config('testing')
        self.yhttp.init_pgpass(self.get_root())

        with open('mbody.properties-testing', 'w') as f:
            f.write('''
mbody.host=http://localhost
mbody.port={mbody_port}
                '''.format(mbody_port=self.webserver_port()))

    def start(self):
        super(MBodyTesting, self).start(put_pgpass_in_env=True)


class MBodyService(FakeRootComponent):
    NAME = 'mbody-service'
    DEPS = [MBodyTesting]


def main():
    wrap_main(deps_root=MBodyService)
