#ifndef CONTENT_TRANSFORMERS_H_2013_08_27
#define CONTENT_TRANSFORMERS_H_2013_08_27

#include <string>
#include <mail_getter/vdirect/interface.h>
#include <message_body/content_transformers_result.h>

namespace msg_body {

class TransformerAttributes;
struct MessagePart;
class Configuration;

class ContentTransformers {
public:
    ContentTransformers(const Configuration&, TransformerAttributes& attrs,
                        VdirectPtr vdirect);
    ContentTransformersResult apply(MessagePart& part) const;

private:
    void applyUudecodeTransformer(MessagePart& part) const;
    void applyCutTransformer(MessagePart& part) const;
    void applyHighlightTransformer(MessagePart& part) const;

    TransformerAttributes& attrs_;
    VdirectPtr vdirect_;
    mutable ContentTransformersResult result_; // FIXME: remove mutable
};

}

#endif // CONTENT_TRANSFORMERS_H_2013_08_27
