#pragma once

#include <string>
#include <vector>

#include <mail_getter/vdirect/interface.h>

#include <internal/message_tree.h>
#include <internal/config.h>
#include <internal/message_context.h>
#include <internal/transformers/transformers.h>
#include <message_body/daria_result.h>
#include <internal/macs/factory.h>

class MessageAccess;
class InlineSpoofer;

namespace msg_body {

class TransformerAttributes;


class DariaViewMaker {
public:
    DariaViewMaker(const Configuration& config,
        TransformerAttributes& attrs,
        LogPtr logger,
        MessageAccess& messageAccess,
        IContentTypeDetector& contentTypeDetector,
        const AliasClassList& aliasClassList,
        unsigned trimThreshold,
        const std::string& timeZone,
        VdirectPtr vdirect,
        const Sanitizer& sanitizer,
        AsyncMacsServicePtr asyncMacsService,
        const InlineSpoofer& inlineSpoofer,
        const Recognizer::Wrapper& recognizer,
        const TextAsyncFactExtractor& asyncFactExtractor,
        macs::Attachments attachments);
    void clear();
    DariaResult createDariaMessage(const std::string& hid);
private:
    DariaResult formDariaMessageWithFallback(MessageTree& messageTree,
        MessageParts& messageParts, const std::string& hid);
    DariaResult formDariaMessage(MessageParts& messageParts, const std::string& hid);
    DariaResult formFallbackDariaMessage(MessageTree& messageTree,
        const std::string& hid, const std::string& excludeHid);

    void recognizeParts(MessageParts& messageParts);
    DariaBodyResult formTextBody(MessagePart& part);
    DariaBodiesResult formTextBodies();
    TransformersResultPtr formAttachment(MessagePart& part);
    TransformPartsResult formAttachments();
    TransformersResultPtr formSignature(MessagePart& part);
    TransformPartsResult formSignatures();
    TransformersResultPtr formCalendar(MessagePart& part);
    TransformPartsResult formCalendars();
    TransformersResultPtr formPassbookPackage(MessagePart& part);
    TransformPartsResult formPassbookPackages();
    TransformPartsResult tryFormWindatAttaches(MessagePart& part);
    DariaInfoResult formInfo(const std::string& hid) const;
    DariaAddressesResult formAddresses(const std::string& addressStr, const std::string& direction) const;
    DariaAddressesResult formAddresses(const MetaAttributes& headerMeta, const std::string& attr) const;
    void parseAddressHeader(const std::string &src, std::string &email) const;

    void parseTransformerAttributesFromHeaders(TransformerAttributes& attrs, MessageAccess& messageAccess) const;
    boost::optional<const MessagePart&> findMainTextPart() const;

    MessageParts textParts_;
    MessageParts rawParts_;
    MessageParts signatureParts_;
    MessageParts calendarParts_;
    MessageParts passbookParts_;
    TransformerAttributes& transformerAttributes_;
    LogPtr logger_;
    const Configuration& config_;
    MessageAccess& messageAccess_;
    MessageContext messageContext_;
    Transformers transformers_;
    MessageTreeCreator messageTreeCreator_;
    std::string timeZone_;
    const std::string requestId_;
    AsyncMacsServicePtr asyncMacsService_;
    const Recognizer::Wrapper& recognizer;
};

std::string extractNoReplyMessageId(const std::string& messageIdHeader);

}
