#ifndef EXCEPTIONS_H_2014_01_23
#define EXCEPTIONS_H_2014_01_23

#include <stdexcept>

namespace msg_body {

struct MessageBodyException: public virtual std::runtime_error {
    MessageBodyException(const std::string& msg)
        : std::runtime_error(msg)
    {}

    virtual ~MessageBodyException() {
    }
};

struct ParamsException: public virtual std::runtime_error {
    ParamsException(const std::string& msg)
        : std::runtime_error(msg) {
    }

    virtual ~ParamsException() {
    }
};

struct MessageBodyParamsException: public MessageBodyException,
                                   public ParamsException {
    MessageBodyParamsException(const std::string& msg)
        : std::runtime_error(msg), MessageBodyException(msg), ParamsException(msg) {
    }
};

struct MessageFormingException: public MessageBodyException {
    MessageFormingException(const std::string& msg)
        : std::runtime_error(msg), MessageBodyException(msg)
    {}
};

struct VdirectException: public MessageBodyParamsException {
    VdirectException(const std::string& msg)
        : std::runtime_error(msg), MessageBodyParamsException(msg)
    {}
};

class TransformersException: public virtual std::runtime_error {
public:
    TransformersException(const std::string& msg)
        : std::runtime_error(msg)
    {}

    virtual ~TransformersException() {
    }
};

struct TransformersParamsException: public TransformersException,
                                    public ParamsException {
    TransformersParamsException(const std::string& msg)
        : std::runtime_error(msg), TransformersException(msg), ParamsException(msg) {
    }
};

class MessagePartException: public virtual std::runtime_error {
public:
    MessagePartException(const std::string& msg, const std::string& hid)
        : std::runtime_error(msg), partHid_(hid)
    {}

    virtual ~MessagePartException() {
    }

    const std::string& partHid() const {
        return partHid_;
    }
private:
    std::string partHid_;
};

}

#endif // EXCEPTIONS_H_2014_01_23
