#ifndef EXT_VIDEO_H_2013_11_26
#define EXT_VIDEO_H_2013_11_26

#include <pcre.h>
#include <list>
#include <libxml/tree.h>
#include <message_body/embed_info.h>

namespace msg_body {

struct TParamString {
    std::string text;
    std::list<std::string> params;
};

typedef struct std::pair<pcre*,std::vector<std::string> > TRegexp;
typedef std::list<TRegexp> TRegexpList;

struct TVideoHosting {
    void freeRegexps(void);

    std::string url;
    std::string name;
    TRegexpList regexpList;
    TParamString player_url;
    TParamString flashvars;
    int height;
    int width;
};

class ExtVideo {
public:
   ~ExtVideo(void);
    int loadHostings ( const std::string &location );
    int checkUrl ( const std::string &url, msg_body::EmbedInfo &embed );
private:
    std::list<TVideoHosting> hosting_list;
};

struct ExtVideoSingleton {
    ExtVideo& instance() { return _instance; }

private:
    static ExtVideo _instance;
};

}

#endif // EXT_VIDEO_H_2013_11_26
