#ifndef YANDEX_MAIL_WMI_EXTERNALTRANSFORMERSSELECTOR_H_
#define YANDEX_MAIL_WMI_EXTERNALTRANSFORMERSSELECTOR_H_

#include <string>

#include <memory>
#include <map>

#include <mail_getter/mime_type.h>
#include <message_body/ext_transformers_selector_result.h>


namespace msg_body {

class ExternalTransformersSelector {
public:
    static void init(const std::string& filename);
    static const ExternalTransformersSelector* Instance(){
        return instance_.get();
    }

    bool by_ct(const std::string& ct, std::string& transformer, std::string& filetype) const;
    bool by_ext(const std::string& ext, std::string& transformer, std::string& filetype) const;
    const std::string& by_ext(const std::string& ct) const;

    /**
     * Creates external transformers information.
     * @param filename Name of file that part handles.
     * @param type Mime type
     * @param subtype Muime subtype
     * @param vr - ViewRepresentation -- output of this function.
     */
    static ExternalTransformersSelectorResult addExternalTransformersInfo(
        const std::string& filename, const std::string& type, const std::string& subtype);

    static bool getTransformerAndFiletype(const MimeType& mType, const std::string& ext, std::string& transformer, std::string& filetype);
private:
    ExternalTransformersSelector(const std::string& filename);
    static std::unique_ptr<ExternalTransformersSelector> instance_;

    typedef std::pair<std::string, std::string> TransformerType; //transformer_name,
                                                                     //file_type
    typedef std::map<std::string, TransformerType> TransformersMap;
    TransformersMap external_transformers_ct;
    TransformersMap external_transformers_ext;

};

}

#endif
