#pragma once

#include <string>
#include <internal/fact_extractor/query.h>
#include <internal/fact_extractor/transport.h>

namespace msg_body {

class FactExtractor {
public:
    using RequestPtr = std::shared_ptr<http_getter::Request>;
    typedef msg_body::Query Query;
    typedef msg_body::TransportImpl Transport;
    typedef Transport::Config Config;

    FactExtractor(const Config& config)
        : transport_(config)
    {}

    Query extract(const std::string& content) const;

private:
    const Transport& transport() const {
        return transport_;
    }

    Transport transport_;
}; //class FactExtractor

}
