#ifndef PARSER_CONFIG_H_2013_12_18
#define PARSER_CONFIG_H_2013_12_18

#include <boost/shared_ptr.hpp>
#include <internal/fact_extractor/query.h>
#include <internal/logger.h>

namespace msg_body {

struct TypeMsg {
    typedef int Type;
    typedef std::vector<Type> Types;
    typedef Query::Entities Entities;

    Entities entities;
    Types include;
    Types exclude;
};

struct ParserConfig {
    typedef TypeMsg Rule;
    typedef std::vector<Rule> Rules;

    Rules rules;
};

ParserConfig createParserConfig (const std::string & path, LogPtr logger);

} // namespace msg_body

#endif /* PARSER_CONFIG_H_2013_12_18 */
