#include <string>
#include <list>
#include <mail_getter/vdirect/interface.h>
#include <message_body/embed_info.h>

namespace hiliter {
    using std::string;
    using std::list;

    using namespace msg_body;

    const int PRIO_VDIRECT = -123;

    struct state;

    struct Params {
        std::string uid;
        VdirectPtr vdirect;
        Params( const std::string & uid, VdirectPtr vdirect)
            : uid(uid)
            , vdirect(vdirect)
        {}
    };

    struct overlay {
        overlay(int b, int e, int p, const string& prefix, const string& suffix)
            : begin(b), end(e), prio(p), p(prefix), s(suffix) {}

        string accumulate(const string& src, size_t& pos, const Params& params) {
            size_t i = pos;
            if(prio < 0 && prio > PRIO_VDIRECT) return "";
            pos = static_cast<std::size_t>(end);
            std::string outset = src.substr(i, static_cast<std::size_t>(begin) - i);
            std::string item = src.substr(static_cast<std::size_t>(begin), static_cast<std::size_t>(end - begin));
            if (prio == PRIO_VDIRECT) {
                item = params.vdirect->processA(item);
            } else {
                item = p + item + s;
            }
            return outset + item;
        }

        string extractUrl(const string& src) {
            return p + src.substr(static_cast<std::size_t>(begin), static_cast<std::size_t>(end - begin));
        }

        int begin, end, prio;
        bool inSrc;
        string p, s;
    };

    struct driver {
        driver(int p, const string& pre, const string& suf, list<overlay>& r, bool e = false)
            : prio(p), prefix(pre), suffix(suf), res(r), _extractMode(e) {}
        virtual ~driver() {}

        void set(state *ns);
        void run(const string& src, size_t pos);
        void push(int begin, int end);
        void push(int prio, int begin, int end);
        void push(int prio, int begin, int end,
                  const string& pp, const string& ss);

        bool extractMode() { return _extractMode; }


    private:
        typedef std::unique_ptr<state> SUPtr;

        std::vector<SUPtr> previousStates;
        SUPtr s;
        int prio;
        const string prefix, suffix;
        list<overlay>& res;

    protected:
        bool _extractMode;
    };



    struct state {
        state(driver& d): drv(d) {}
        virtual ~state(void) {}

        virtual void run(const string& src, size_t pos) = 0;

        void push(int begin, int end) {
            drv.push(begin, end);
        }

        void push(int prio, int begin, int end) {
            drv.push(prio, begin, end);
        }

        void push(int prio, int begin, int end,
                  const string& pp, const string& ss) {
            drv.push(prio, begin, end, pp, ss);
        }

        bool extractMode() { return drv.extractMode(); }

        template <typename S, typename... Args>
        void set(Args&&... args) {
            drv.set(new S(drv, std::forward<Args>(args)...));
        }
    private:
        driver& drv;
    };

    string hilite(const string& src, EmbedInfos& el, const Params& params);

    namespace url {
        struct driver: public hiliter::driver {
            driver(list<overlay>& r, EmbedInfos& el, const Params& params, bool extractMode);
        };
    }

    namespace email {
        struct driver: public hiliter::driver {
            driver(list<overlay>& r);
        };
    }

    namespace phone {
        struct driver: public hiliter::driver {
            driver(list<overlay>& r);
        };
    }

    namespace tag {
        struct driver: public hiliter::driver {
            driver(list<overlay>& r);
        };
    }
}
