#pragma once

#include <mail_getter/types.h>
#include <internal/config.h>
#include <internal/logger.h>
#include <internal/message_context.h>
#include <internal/transformer_attributes.h>
#include <internal/yield_context.h>

class MessageAccess;

namespace msg_body {

class InlineSpoofer {
public:
    virtual ~InlineSpoofer() {}
    virtual std::string getUrl(const CidPartInfo& cidInfo) const = 0;
};

using InlineSpooferPtr = std::unique_ptr<InlineSpoofer>;

class DraftInlineSpoofer: public InlineSpoofer {
public:
    DraftInlineSpoofer(const Configuration& config,
        LogPtr logger,
        mail_getter::ServicePtr storageService,
        MessageAccess& messageAccess,
        const mail_getter::attach_sid::Keys& keys,
        YieldCtx yc);

    std::string getUrl(const CidPartInfo& cidInfo) const override;

private:
    MimeType getContentType(MetaPart& hs, const mail_getter::Hid& hid,
        const std::string& filename, const std::string& body) const;

    const Configuration& config_;
    LogPtr logger_;
    mail_getter::ServicePtr storageService_;
    MessageAccess& messageAccess_;
    const mail_getter::attach_sid::Keys& keys_;
    YieldCtx yc_;
};

class MainInlineSpoofer: public InlineSpoofer {
public:
    MainInlineSpoofer(const std::string& uid)
        : uid_(uid)
    {}

    std::string getUrl(const CidPartInfo& cidInfo) const override;
private:
    std::string uid_;
};

InlineSpooferPtr getInlineSpoofer(const Configuration& config, LogPtr logger,
    const TransformerAttributes& attrs, mail_getter::ServicePtr storageService,
    MessageAccess& messageAccess, YieldCtx yc);

} // namespace msg_body

