#pragma once

#include <memory>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

#include <yplatform/log.h>

#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <macs/types.h>

namespace msg_body {

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(std::string&, stid)
LOGDOG_DEFINE_ATTRIBUTE(std::string&, pattern)
LOGDOG_DEFINE_ATTRIBUTE(std::string, hid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, mid)
LOGDOG_DEFINE_ATTRIBUTE(std::vector<macs::Mid>, mids)

using namespace ::logdog::attr;

constexpr static auto phishing_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-phishing-tskv-log"));
constexpr static auto mbody_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-mbody-tskv-log"));


} // namespace log

using Logger = yplatform::log::source;

inline Logger getLogger() {
    return Logger(YGLOBAL_LOG_SERVICE, "message_body");
}

inline auto makeTvmGuardLogger() {
    return logdog::make_log(
        log::mbody_formatter,
        yplatform::log::source {YGLOBAL_LOG_SERVICE, "tvm_guard"}
    );
}

using TvmGuardLogger = decltype(makeTvmGuardLogger());
using TvmGuardLoggerPtr = std::shared_ptr<TvmGuardLogger>;

inline auto makeMbodyLogger() {
    return logdog::make_log(
        log::mbody_formatter,
        yplatform::log::source {YGLOBAL_LOG_SERVICE, "message_body"}
    );
}

inline auto makePhishingLogger() {
    return logdog::make_log(
        log::phishing_formatter,
        yplatform::log::source {YGLOBAL_LOG_SERVICE, "phishing"}
    );
}

using MbodyLogger = decltype(makeMbodyLogger());

inline auto makeLoggerWithRequestId(const std::string& requestId) {
    return logdog::bind(makeMbodyLogger(), logdog::request_id = requestId);
}

using ContextLogger = decltype(makeLoggerWithRequestId(""));

inline auto getLoggerWithUidMids(ContextLogger logger, macs::Uid uid, std::vector<macs::Mid> mids) {
    return logdog::bind(logger, log::uid = uid, log::mids = mids);
}

using LogPtr = std::shared_ptr<ContextLogger>;

} // namespace

#define MBODY_LOG_DEBUG(logger, ...) \
    LOGDOG_(*logger , debug, __VA_ARGS__); 

#define MBODY_LOG_INFO(logger, ...) \
    LOGDOG_(*logger, notice, __VA_ARGS__);

#define MBODY_LOG_WARN(logger, ...) \
    LOGDOG_(*logger, warning, __VA_ARGS__);

#define MBODY_LOG_ERROR(logger, ...) \
    LOGDOG_(*logger, error, __VA_ARGS__);

