#pragma once

#include <internal/logger.h>
#include <internal/macs/logging.h>
#include <message_body/message_body_params.h>
#include <macs_pg/macs_pg.h>
#include <mail_getter/hooks.h>
#include <internal/yield_context.h>
#include <mail/ymod_maildb/include/module.h>


namespace msg_body {

using MacsParams = ymod_maildb::ServiceParams;
using JournalParams = ymod_maildb::UserJournalParams;

class AsyncMacsService {
public:
    AsyncMacsService(const ymod_maildb::Module& maildb, MacsParams params,
            JournalParams ujParams, const LogPtr& logger, YieldCtx yc)
            : yc_{std::move(yc)} {
        params.module = "message_body";
        service_ = maildb.service(std::move(params), std::move(ujParams), createMacsPgLogger(*logger), macs::pg::readNoLagReplicaThenMasterThenReplica);
    }

    decltype(auto) getMimes(const macs::Mids& mids) const {
        return service_->envelopes().getMimes(mids,
            mail_getter::io::make_yield_context(yc_));
    }

    decltype(auto) getMimesWithAttaches(const macs::Mids& mids, mail_errors::error_code& ec) const {
        return service_->envelopes().getMimesWithAttaches(mids, mail_getter::io::make_yield_context(yc_)[ec]);
    }

    decltype(auto) getMimesWithAttachesWithDeleted(const macs::Mids& mids, mail_errors::error_code& ec) const {
        return service_->envelopes().getMimesWithAttachesWithDeleted(mids, mail_getter::io::make_yield_context(yc_)[ec]);
    }

    decltype(auto) getMimes(const macs::Mids& mids, mail_errors::error_code& ec) const {
        return service_->envelopes().getMimes(mids,
            mail_getter::io::make_yield_context(yc_)[ec]);
    }

    decltype(auto) getMimesWithDeleted(const macs::Mids& mids) const {
        return service_->envelopes().getMimesWithDeleted(mids,
            mail_getter::io::make_yield_context(yc_));
    }

    decltype(auto) getById(const macs::Mid& mid) const {
        return service_->envelopes().getById(mid,
            mail_getter::io::make_yield_context(yc_));
    }

    decltype(auto) getOrCreateLabel(const macs::Label::Symbol& symbol) const {
        return service_->labels().getOrCreateLabel(symbol,
            mail_getter::io::make_yield_context(yc_));
    }

    decltype(auto) getWindatMimes(const macs::Mids& mids, mail_errors::error_code& ec) const {
        return service_->envelopes().getWindatMimes(mids,
            mail_getter::io::make_yield_context(yc_)[ec]);
    }

private:
    macs::ServicePtr service_;
    YieldCtx yc_;
};

using AsyncMacsServicePtr = std::shared_ptr<AsyncMacsService>;

AsyncMacsServicePtr getAsyncMacsService(const ymod_maildb::Module& maildb, MacsParams params, JournalParams ujParams,
                                         const LogPtr& logger, YieldCtx yc);

} // namespace msg_body
