#ifndef MAIL_QUOTE_ABSTRACT_PARAGRAPH_VISITOR_H
#define MAIL_QUOTE_ABSTRACT_PARAGRAPH_VISITOR_H

#include <internal/mail_quote/abstract_visitor.h>

namespace msg_body {
namespace mail_quote {

class AbstractParagraphVisitor {
public:
    virtual ~AbstractParagraphVisitor() {}

    virtual void visit() = 0;
    virtual void leave() = 0;
    virtual void visitParagraph() = 0;
    virtual void leaveParagraph() = 0;
    virtual void visitQuotation() = 0;
    virtual void leaveQuotation() = 0;
    virtual void visitText() = 0;
    virtual void leaveText() = 0;
    virtual void visitSignature() = 0;
    virtual void leaveSignature() = 0;
    virtual void visitLine() = 0;
    virtual void leaveLine() = 0;
    virtual void visitSymbol(Iterator iterator) = 0;
    virtual void leaveSymbol(const Range& range) = 0;

    virtual std::string&& result() = 0;
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_ABSTRACT_PARAGRAPH_VISITOR_H
