#ifndef MAIL_QUOTE_ABSTRACT_VISITOR_H
#define MAIL_QUOTE_ABSTRACT_VISITOR_H

#include <string>
#include <boost/range/iterator_range.hpp>
#include <internal/mail_quote/tokenizer.h>

namespace msg_body {
namespace mail_quote {

using Iterator = TokenSequence::const_iterator;
using Range = boost::iterator_range<Iterator>;

class AbstractVisitor {
public:
    virtual ~AbstractVisitor() {}

    virtual void visit(int quotationLevel, Iterator current) = 0;
    virtual void leave(int quotationLevel, const Range &range) = 0;
    virtual void visitQuotation(int quotationLevel, Iterator current) = 0;
    virtual void leaveQuotation(int quotationLevel, const Range& range) = 0;
    virtual void visitText(int quotationLevel, Iterator current) = 0;
    virtual void leaveText(int quotationLevel, const Range& range) = 0;
    virtual void visitSignature(int quotationLevel, Iterator current) = 0;
    virtual void leaveSignature(int quotationLevel, const Range& range) = 0;
    virtual void visitSymbol(int quotationLevel, Iterator current) = 0;
    virtual void leaveSymbol(int quotationLevel, const Range& range) = 0;

    virtual std::string&& result() = 0;
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_ABSTRACT_VISITOR_H
