#ifndef MAIL_QUOTE_PARAGRAPH_VISITOR_H
#define MAIL_QUOTE_PARAGRAPH_VISITOR_H

#include <stack>
#include <butil/xml/entities.h>
#include <internal/mail_quote/abstract_paragraph_visitor.h>

namespace msg_body {
namespace mail_quote {

class ParagraphVisitor : public AbstractParagraphVisitor {
public:
    ParagraphVisitor(Iterator end) : end(end) {}

    virtual void visit() override;
    virtual void leave() override;
    virtual void visitParagraph() override;
    virtual void leaveParagraph() override;
    virtual void visitQuotation() override;
    virtual void leaveQuotation() override {}
    virtual void visitText() override;
    virtual void leaveText() override {}
    virtual void visitSignature() override;
    virtual void leaveSignature() override {}
    virtual void visitLine() override;
    virtual void leaveLine() override;
    virtual void visitSymbol(Iterator iterator) override;
    virtual void leaveSymbol(const Range& range) override;

    std::string&& result() override {
        return std::move(result_);
    }

private:
    struct Paragraph {
        enum class Type {
            None,
            Text,
            Quotation,
            Signature,
        };

        Type type = Type::None;
        std::string content;

        Paragraph() = default;
        Paragraph(Paragraph &&) = default;
        Paragraph(const Paragraph &) = delete;

        Paragraph &operator =(Paragraph &&) = default;
        Paragraph &operator =(const Paragraph &) = delete;
        Paragraph& operator +=(std::string content);
        std::string dump();
    };

protected:
    const std::vector<Paragraph>& getParagraphsStack() const {
        return paragraphsStack;
    }

private:
    static const std::string breakLine;
    static const std::string beginQuotation;
    static const std::string endQuotation;
    static const std::string beginText;
    static const std::string endText;
    static const std::string space;
    static const std::string tab;
    static const std::string beginSignature;
    static const std::string endSignature;
    static const std::string signatureSeparator;

    const Iterator end;
    const XmlEntities entities;
    bool isLineContainsOnlySpaceSymbols = false;
    std::string line;
    std::vector<Paragraph> paragraphsStack;
    std::vector<Paragraph> paragraphsSequence;
    std::string result_;
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_PARAGRAPH_VISITOR_H
