#ifndef MAIL_QUOTE_PARSER_H
#define MAIL_QUOTE_PARSER_H

#include <internal/mail_quote/abstract_visitor.h>

namespace msg_body {
namespace mail_quote {

class Parser {
public:
    Parser(Iterator begin, Iterator end)
            : begin(begin), end(end), textBegin(end) {}

    void operator ()(AbstractVisitor& visitor);

private:
    enum class State {
        NewLine,
        Quotation,
        Text,
    };

    const Iterator begin;
    const Iterator end;
    Iterator current;
    State state = State::NewLine;
    int quotationLevel = 0;
    Iterator textBegin;
    bool signature = false;

    State handleToken(AbstractVisitor& visitor);
    void handleEnd(AbstractVisitor& visitor);

    State whenNewLine(AbstractVisitor& visitor);
    State whenQuotation(AbstractVisitor& visitor);
    State whenText(AbstractVisitor& visitor);
    State whenEnd(AbstractVisitor& visitor);

    void visitLeaveSymbol(AbstractVisitor& visitor);

    static Range range(Iterator begin, Iterator end) {
        return boost::make_iterator_range(begin, end);
    }

    Range symbolRange() const {
        return range(current, current + 1);
    }

    Range textRange() const {
        return range(textBegin, current + 1);
    }
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_PARSER_H
