#ifndef MAIL_QUOTE_TOKEN_H
#define MAIL_QUOTE_TOKEN_H

#include <string>

namespace msg_body {
namespace mail_quote {

class Token {
public:
    enum class Type {
        Ampersand,
        CarriageReturn,
        GreaterThan,
        LessThan,
        LineDelimiter,
        Space,
        Symbols,
        Tab,
        SignatureSeparator,
    };

    static const Token ampersand;
    static const Token carriageReturn;
    static const Token greaterThan;
    static const Token lessThan;
    static const Token lineDelimiter;
    static const Token space;
    static const Token tab;
    static const Token signatureSeparator;

    Token(Type type, std::string value)
        : type_(type), value_(std::move(value)) {}
    Token(std::string value)
        : type_(makeType(value)), value_(std::move(value)) {}

    Type type() const {
        return type_;
    }

    const std::string& value() const {
        return value_;
    }

    bool isSpace() const;

    bool operator ==(const Token& other) const {
        return type_ == other.type_ && value_ == other.value_;
    }

private:
    Type type_;
    std::string value_;

    static Type makeType(const std::string& value);
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_TOKEN_H
