#ifndef MAIL_QUOTE_VISITOR_H
#define MAIL_QUOTE_VISITOR_H

#include <internal/mail_quote/paragraph_visitor.h>

namespace msg_body {
namespace mail_quote {

class Visitor : public AbstractVisitor {
public:
    Visitor(AbstractParagraphVisitor& paragraphVisitor) : paragraphVisitor(paragraphVisitor) {}

    virtual void visit(int quotationLevel, Iterator iterator) override;
    virtual void leave(int quotationLevel, const Range &range) override;
    virtual void visitQuotation(int quotationLevel, Iterator iterator) override;
    virtual void leaveQuotation(int quotationLevel, const Range& range) override;
    virtual void visitText(int quotationLevel, Iterator iterator) override;
    virtual void leaveText(int quotationLevel, const Range& range) override;
    virtual void visitSignature(int quotationLevel, Iterator current) override;
    virtual void leaveSignature(int quotationLevel, const Range& range) override;
    virtual void visitSymbol(int quotationLevel, Iterator iterator) override;
    virtual void leaveSymbol(int quotationLevel, const Range& range) override;

    std::string&& result() override final {
        return std::move(paragraphVisitor.result());
    }

private:
    enum class Visited {
        Nothing,
        Text,
        Signature
    };

    AbstractParagraphVisitor& paragraphVisitor;
    int currentQuotationLevel = 0;
    Visited visited;

    void tryVisitText();
    void tryLeaveText();
    void tryVisitQuotation(int quotationLevel);
    void tryLeaveQuotation(int quotationLevel);
    void tryVisitSignature();
    void tryLeaveSignature();
};

} // namespace mail_quote
} // namespace msg_body

#endif // MAIL_QUOTE_VISITOR_H
