#pragma once

#include <internal/macs/factory.h>
#include <mail_getter/MessageAccess.h>
#include <message_body/daria_result.h>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif
#include <butil/StrUtils/StrUtils.h>
#include <mimeparser/ccnv.h>
#include <butil/network/idn.h>
#ifdef __clang__
#pragma clang diagnostic pop
#endif

namespace msg_body {
    class MedalMaker {
    public:
        MedalMaker(const AsyncMacsServicePtr& asyncMacsService, MetaAttributes& headerMeta,
                const std::string& mid)
                : asyncMacsService_(asyncMacsService), headerMeta_(headerMeta), mid_(mid) {
        }

        void updateResult(DariaInfoResult& res) {
            const std::string sender = headerMeta_.find("return-path") != headerMeta_.end() ? headerMeta_["return-path"]
                                                                                            : headerMeta_["from"];
            res.senderDomain = getSenderDomain(sender);
            res.signedBy = res.dkim.status() == Dkim::valid ? res.dkim.domain() : "";
            res.isSpam = res.spam == "4";

            std::string authResult = headerMeta_.find("authentication-results") != headerMeta_.end()
                ? headerMeta_["authentication-results"] : "";
            if (authResult.find("dkim=pass") != std::string::npos) {
                res.dkimStatus = "pass";
            } else if (authResult.find("dkim=fail") != std::string::npos) {
                res.dkimStatus = "fail";
            }

            if (asyncMacsService_) {
                const macs::Envelope envelope = asyncMacsService_->getById(mid_);
                res.encrypted = envelope.hasLabel(
                        asyncMacsService_->getOrCreateLabel(macs::Label::Symbol::encrypted_label));
            }
            res.collectedRpopId = headerMeta_["x-yandex-rpop-id"];
        }

        static std::string getSenderDomain(const std::string& addr) {
            std::string goodStr = TStrUtils::removeBadSymbols(mulca_mime::decode_numbered_entities(addr));
            std::string domain;
            try {
                rfc2822ns::address_iterator iter(goodStr);
                if (rfc2822ns::address_iterator() != iter) {
                    domain = idna::decode(iter.domain());
                }
            } catch (const rfc2822ns::invalid_address& e) {}
            return domain;
        }
    private:
        AsyncMacsServicePtr asyncMacsService_;
        MetaAttributes& headerMeta_;
        const std::string& mid_;
    };
}
