#ifndef MESSAGE_CONTEXT_H_2013_10_07
#define MESSAGE_CONTEXT_H_2013_10_07

#include <string>
#include <set>
#include <map>

namespace msg_body {

typedef std::set<std::string> Cids;

struct CidPartInfo {
    std::string stid;
    std::string hid;
    std::string mid;
    std::string name;
};

typedef std::map<std::string, CidPartInfo> CidParts;

struct MessageContext {
    CidParts cidParts;
    Cids cids_;
    std::string originalMessageId_;
    bool isOurMessage;
    bool listUnsubscribe_;

    MessageContext() : isOurMessage(false), listUnsubscribe_(false)
    {}

    void clear() {
        cids_.clear();
        originalMessageId_.clear();
        isOurMessage = false;
        listUnsubscribe_ = false;
    }
};

}

#endif // MESSAGE_CONTEXT_H_2013_10_07
