#pragma once

#include <macs/types.h>
#include <butil/tvm_ticket.h>
#include <mail_getter/recognizerWrapper.h>
#include <internal/logger.h>
#include <internal/yield_context.h>

namespace msg_body {

class RequestContext;
class Configuration;

struct MessageSource {
    std::string encoding;
    std::string text;
};

struct MessageSourceParams {
    macs::Uid uid;
    macs::Mid mid;
    std::string requestId;
    tvm::Ticket ticket;
};

MessageSourceParams parseMessageSourceParams(const RequestContext& req);
MessageSource getMessageSource(const Configuration& config, const MessageSourceParams& params,
        LogPtr logger, YieldCtx yield);

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::MessageSource,
    (std::string, encoding)
    (std::string, text)
)
