#pragma once

#include <cstdint>
#include <optional>
#include <string>
#include <vector>

#include <macs/types.h>
#include <yamail/data/reflection.h>

#include <internal/logger.h>
#include <internal/yield_context.h>
#include <internal/server/request_context.h>

namespace msg_body {

class RequestContext;
class Configuration;

struct MessageTextParams {
    macs::Uid uid;
    macs::Mid mid;
    std::optional<std::uint32_t> maxSize;
    std::optional<std::string> service;
    std::string requestId;
};

YREFLECTION_DEFINE_ENUM_INLINE(MessageTextPartMode,
    full,
    trimmed,
    firstline
)

struct MessageText {
    struct Part {
        MessageTextPartMode mode;
        std::string content;
        std::optional<std::string> lang;
    };

    std::vector<Part> textParts;
};

MessageTextParams parseMessageTextParams(const RequestContext& req);
MessageText getMessageText(const Configuration& config, const MessageTextParams& params, LogPtr logger, YieldCtx yield);

} // namespace msg_body

BOOST_FUSION_ADAPT_STRUCT(msg_body::MessageText::Part,
    mode,
    content,
    lang
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::MessageText,
    textParts
)
