#pragma once

#include <string>
#include <map>
#include <vector>
#include <boost/shared_ptr.hpp>

#include <mail_getter/MessageAccessDefinitions.h>
#include <mail_getter/content_type.h>

#include <message_body/embed_info.h>
#include <message_body/part_class_info.h>
#include <message_body/part_type_info.h>
#include <message_body/message_part.h>
#include <macs/envelope.h>

class MessageAccess;
class AliasClassList;

namespace msg_body {

typedef std::vector<MessagePart> MessageParts;

struct MessageTree {
    MessageTree() : isValid(true) {}
    typedef boost::shared_ptr<MessageTree> Ptr;
    typedef std::map<size_t, Ptr> Children;
    MessagePart part;
    Children children;
    bool isValid;
};

class MessageTreeException: public std::runtime_error {
public:
    MessageTreeException(const std::string& message)
        : std::runtime_error(message)
    {}
};

class MessageTreeCreator {
public:
    MessageTreeCreator(MessageAccess& messageAccess, IContentTypeDetector& contentTypeDetector,
            macs::Attachments attachments);
    MessageTree create(const std::string& hid) const;

private:
    void processTree(const std::string& hid, MessageTree& messageTree, size_t level) const;
    void fillPart(const std::string& hid, MessagePart& messagePart) const;
    void fillAttachmentSize(const std::string& hid, MessagePart& messagePart) const;
    MimeType detectContentType(const std::string& fileName) const;
    void detectAttrsContentType(MessagePart& messagePart) const;

    MessageAccess& messageAccess_;
    IContentTypeDetector& contentTypeDetector_;
    macs::Attachments attachments_;
};

size_t localHidPart(const std::string& hid);

MetaAttributes getMessageHeaderParsed(MessageAccess& messageAccess, const std::string& hid);
std::string getMessageBody(MessageAccess& messageAccess, const std::string& hid);

MessagePartTypeInfo getTypeInfo(MessagePart& part, const IContentTypeDetector& contentTypeDetector,
                                const AliasClassList& aliasClassList);

}
