#ifndef MESSAGE_WALKER_H_2013_10_28
#define MESSAGE_WALKER_H_2013_10_28

#include <internal/message_tree.h>

namespace msg_body {

class MessageWalker {
public:
    void make(MessageTree& tree);
    bool make(MessageTree& tree, const std::string& invalidPartHid);
    const MessageParts& parts() const;

private:
    void makePart(MessageTree& tree);
    void makeMultipart(MessageTree& tree);
    void makeMixed(MessageTree& tree);
    void makeSigned(MessageTree& tree);
    void makeAlternative(MessageTree& tree);
    void makeSimplePart(MessageTree& tree);
    void makeMessage(MessageTree& tree);
    void makeChildrenCalendars(MessageTree& tree);
    void makeAlternativeChild(MessageTree& tree);
    void makeChildPart(const MessageTree::Children::value_type& node);
    void makeAltCalendarChildPart(const MessageTree::Children::value_type& node);
    bool markInvalidNodes(MessageTree& tree, const std::string& invalidPartHid);
    bool markInvalidChildNodes(MessageTree::Children::value_type& node, const std::string& invalidPartHid);
    bool hasInvalidChildren(MessageTree& tree, const std::string& invalidPartHid);
    bool hasValidAlternativeChild(MessageTree& tree);

    MessageParts parts_;
};

}

#endif // MESSAGE_WALKER_H_2013_10_28
