#pragma once

#include <mail_getter/mulcagate/http.h>
#include <internal/http_call.h>

namespace msg_body {

class MulcagateHttpClientAdaptor: public mail_getter::mulcagate::http::HttpClient {
public:
    using BaseParams = mail_getter::mulcagate::http::BaseParams;
    using Response = mail_getter::mulcagate::http::Response;
    using Handler = mail_getter::mulcagate::http::ResponseHandler;

    void aget(const BaseParams& params, Handler handler) const override {
        using namespace http_getter;
        Request request = get(makeUrl(params))
                         .headers("hdrs"_hdr=params.headers, requestId=params.requestId, serviceTicket=getMulcagateServiceTicket())
                         .getArgs("args"_arg=params.args)
                         .keepAlive(params.keepAlive)
                         .timeouts(params.timeout, params.connectTimeout)
                         .make();
        aop(request, std::move(handler), params.requestId);
    }

    void apost(const BaseParams& params, const std::string& data, Handler handler) const override {
        using namespace http_getter;
        Request request = post(makeUrl(params))
                         .headers("hdrs"_hdr=params.headers, requestId=params.requestId, serviceTicket=getMulcagateServiceTicket())
                         .getArgs("args"_arg=params.args)
                         .keepAlive(params.keepAlive)
                         .timeouts(params.timeout, params.connectTimeout)
                         .body(data)
                         .make();
        aop(request, std::move(handler), params.requestId);
    }
private:
    void aop(http_getter::Request request, Handler handler, const std::string& reqId) const {
        using yplatform::task_context;
        using namespace http_getter;
        asyncRun(*getClusterClient("mulcagate_client"), boost::make_shared<task_context>(reqId), request,
            [handler = std::move(handler)] (boost::system::error_code ec, yhttp::response response) {
                if (ec) {
                    handler(mail_getter::error_code(ec), Response());
                } else {
                    handler(mail_getter::error_code(), Response(static_cast<unsigned>(response.status), std::move(response.body)));
                }
            });
    };

    static std::string makeUrl(const BaseParams& params) {
        return params.path;
    }

    GetClusterClient getClusterClient = makeGetClusterClient();
};

inline mail_getter::mulcagate::http::HttpClientPtr getMulcagateHttpClientAdaptor() {
    return std::make_shared<MulcagateHttpClientAdaptor>();
}

} // namespace msg_body
