#pragma once

#include <mail_getter/logging.h>
#include <internal/logger.h>

namespace msg_body {

class MulcagateLog : public mail_getter::logging::Log {
public:
    using ServiceName = mail_getter::logging::ServiceName;
    using Message = mail_getter::logging::Message;

    MulcagateLog(const std::string& requestId) 
        : logger(makeLoggerWithRequestId(requestId))
        , requestId(requestId)
    {}

    void warning(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, warning, log::request_id = requestId, log::where_name=name, log::message=msg);
    }
    void error(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, error, log::request_id = requestId, log::where_name=name, log::message=msg);
    }
    void notice(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, notice, log::request_id = requestId, log::where_name=name, log::message=msg);
    }
    void debug(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, debug, log::request_id = requestId, log::where_name=name, log::message=msg);
    }
    static mail_getter::logging::LogPtr create (const std::string& requestId) {
        return std::make_shared<MulcagateLog>(requestId);
    }
private:
    ContextLogger logger;
    std::string requestId;
};

} // namespace msg_body
