#pragma once

#include <string>
#include <internal/logger.h>

namespace msg_body {

class Configuration;

enum class NestedTagsCheckerResult {
    Ok,
    ParseError,
    TagsDepthLimitExceeded
};

class NestedTagsChecker {
public:
    NestedTagsChecker(const Configuration& config, const LogPtr& logger) noexcept;
    NestedTagsChecker(NestedTagsChecker&&) = default;

    NestedTagsCheckerResult check(const std::string& content);

private:

    LogPtr logger;
    const Configuration& config;
};

}
