#pragma once

#include <pa/async.h>

namespace msg_body {

class PaLog {
public:
    using Clock = std::chrono::steady_clock;


    PaLog(std::string method, std::string id = "")
            : method(std::move(method))
            , id(std::move(id)) {
    }

    void write() const {
        using std::chrono::milliseconds;
        using std::chrono::duration_cast;
        const auto duration = duration_cast<milliseconds>(Clock::now() - start).count();
        pa::async_profiler::add(pa::message_body, "", method, id, std::uint32_t(duration));
    }

private:
    std::string method;
    std::string id;
    Clock::time_point start = Clock::now();
};

} // namespace msg_body
