#pragma once

#include <stdexcept>
#include <string>
#include <vector>
#include <message_body/passbook.h>
#include <mail_getter/recognizerWrapper.h>

namespace msg_body {

PassbookPackage parsePassbookDict(const std::string& passDict);
PassbookPackage parsePassbookPackage(const Recognizer::Wrapper& recognizer, const std::string& data);

class PassbookPackageException: public std::runtime_error {
public:
    PassbookPackageException(const std::string& msg)
        : std::runtime_error(msg)
    {}
};

}
