#pragma once

#include <memory>
#include <internal/search/regular.h>
#include <internal/search/wu_manber.h>

namespace msg_body {

class PhishingChecker : public Regular {
    public:
        PhishingChecker()
        : Regular ()
        {}
        bool check(const std::string& text, std::string& matched);
        void initPhishingChecker(const std::string& file);
        void loadPatternFrom(const std::string& file);
    private:
        /**
         * WuManber can be in "off" state due to memory consumption policy;
         * if NULL==wm.get(), then WuManber is "off", and "on" in other case.
         */
        std::unique_ptr<WuManber> wm;
};

struct PhishingSingleton {
    PhishingChecker& instance() { return _instance; }

private:
    static PhishingChecker _instance;
};

}
