#pragma once

#include <optional>
#include <functional>

#include <internal/message_context.h>
#include <internal/sanitizer.h>
#include <internal/inline_spoofer.h>

namespace msg_body {

struct SanitizeTransformParams {
    std::optional<std::reference_wrapper<const CidParts>> cidParts;

    auto& SetCidParts(const CidParts& cidParts) {
        this->cidParts = std::cref(cidParts);
        return *this;
    }
};

struct SanitizeTransformResult {
    std::string content;
    Cids cids;
};

SanitizeTransformResult sanitizeTransform(const InlineSpoofer& inlineSpoofer,
    mail_getter::SanitizerParsedResponse &sanitizeData, const SanitizeTransformParams& params);

} // namespace msg_body
