#pragma once

#include <string>
#include <pcre.h>
#include <vector>
#include <optional>
#include <butil/thread/rwlock.h>

class Regular
{
 public:
  Regular() {}

  Regular ( const std::string & regex_file ) :
  file ( regex_file )
  {
    initRegexp();
    re_table = pcre_maketables();
  }

  int search ( const std::string & text, std::string& matched );

  void initRegular ( const std::string & file );

  ~Regular () { freeRegexp(); }

 private:

  struct Regexp
  {
  public:
   Regexp()
       : exp (NULL)
       , extra (NULL)
   {}

   virtual ~Regexp ()
   {
    pcre_free(exp);
    pcre_free(extra);
   }

   pcre * exp;
   pcre_extra * extra;
   std::string orig;
  };

  virtual int initRegexp();

  virtual int find ( const std::string & text, std::string& matched );

  int loadRegexp( std::vector<std::string> & lines );

  void freeRegexp( );

  virtual bool checkFileChanged();

  std::string getFileTimeStamp ();

  std::vector<Regexp*> regexp_vec;

  std::string file;

  std::optional<std::string> mtime;

  rwlock rwLock;

  const unsigned char *re_table;

 protected:
  int compileRegexp( std::vector<std::string> & lines );

};
