#pragma once

#include <internal/config.h>
#include <internal/yield_context.h>
#include "request_context.h"


BOOST_FUSION_DEFINE_STRUCT((msg_body), ConfigChangeResult,
)

namespace msg_body {

class ConfigChangeHandler {
public:
    ConfigChangeHandler(Configuration& config)
        : config_(config)
        , originalValue_(config.sanitizerStrategy)
        { }

    ConfigChangeResult operator ()(RequestContext& req, YieldCtx yc) const;

private:
    Configuration& config_;
    sanitizer::Strategy originalValue_;
};

}
