#pragma once

#include <internal/extract_headers.h>
#include "request_context.h"

namespace msg_body {

class HeadersHandler {
public:
    HeadersHandler(const Configuration& config)
        : config_(config)
    {}

    Mids2MessageHeaders operator ()(RequestContext& req, YieldCtx yc) const {
        const MessagesHeadersParams msgsHeadersParams = parseMessagesHeadersParams(req);

        return extractMessagesHeaders(config_, msgsHeadersParams, req.logger(), yc);
    }

private:
    const Configuration& config_;
};

}
