#pragma once

#include <butil/http/headers.h>

namespace msg_body {

template <typename Configuration, typename RequestContext>
inline http::headers getHeadersToPass(const Configuration &config, const RequestContext &req) {
    http::headers headers;
    for (const std::string& name: config.headersToPass) {
        if (auto val = req.getOptionalHeader(name)) {
            headers.add(name, *val);
        }
    }
    return headers;
}

}
