#pragma once

#include <message_body/daria_result.h>
#include <internal/message_body.h>
#include "request_context.h"
#include "headers_to_pass.h"

namespace msg_body {

class MessageHandler {
public:
    MessageHandler(const Configuration& config)
        : config_(config)
    {}

    DariaResult operator ()(RequestContext& req, YieldCtx yc) const {
        const MessageBodyParams params = parseMessageBodyParams(req);
        const http::headers headersToPass = getHeadersToPass(config_, req);

        return formMessageBody(config_, params, headersToPass, req.logger(), yc);
    }

private:
    const Configuration& config_;
};

}
