#pragma once

#include <internal/message_source.h>
#include "request_context.h"

namespace msg_body {

class MessageSourceHandler {
public:
    MessageSourceHandler(const Configuration& config)
        : config_(config)
    {}

    MessageSource operator ()(RequestContext& req, YieldCtx yc) const {
        const auto params = parseMessageSourceParams(req);

        return getMessageSource(config_, params, req.logger(), yc);
    }

private:
    const Configuration& config_;
};

}
