#pragma once

#include <internal/config.h>
#include <internal/message_text.h>
#include <internal/yield_context.h>
#include "request_context.h"

namespace msg_body {

class MessageTextHandler {
public:
    MessageTextHandler(const Configuration& config)
        : config_(config) {
    }

    MessageText operator ()(RequestContext& req, YieldCtx yc) const {
        const auto params = parseMessageTextParams(req);

        return getMessageText(config_, params, req.logger(), yc);
    }

private:
    const Configuration& config_;
};

} // namespace msg_body
