#pragma once

#include <yamail/data/serialization/json_writer.h>

namespace msg_body {
namespace reflection {

struct Response {
    std::string result;
    std::string error;
};

inline std::string toJson(const Response& response) {
    return yamail::data::serialization::toJson(response).str();
}

} // namespace reflection
} // namespace msg_body


BOOST_FUSION_ADAPT_STRUCT(msg_body::reflection::Response,
    (std::string, result)
    (std::string, error)
)
