#pragma once

#include <string>
#include <set>
#include <list>
#include <optional>
#include <boost/bind.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string/join.hpp>
#include <boost/range/adaptor/transformed.hpp>
#include <message_body/embed_info.h>
#include <internal/sanitizer_tykva.h>

namespace msg_body {

class TransformerAttributes {
public:
    std::string useCharset;
    std::time_t messageDate;
    long timeZoneOffset;
    std::string messageSubject;
    std::string to;
    std::string uid;
    std::string mid;

    std::string from;
    std::set<int> types;
    std::string lang;
    std::string requestId;
    sanitizer::Strategy sanitizerStrategy;
    std::optional<std::string> system;

    /**
     * Must be dynamic and text-based ?
     */
    struct _flags {
        unsigned ignoreHighlight    : 1;
        unsigned showContentMeta    : 1;
        unsigned cutSignature       : 1;
        unsigned outputAsCDATA      : 1;
        unsigned xmlStreamerOn      : 1;
        unsigned xmlStreamerMobile  : 1;
        unsigned noVdirectLinksWrap : 1;
        unsigned sequentialFactex   : 1;
        unsigned draft              : 1;
        unsigned noTrim             : 1;
    } flags;

    void setFlags ( const std::string & str_flags ) {
        if ( str_flags.empty() ) {
            return;
        }
        flags.ignoreHighlight = str_flags.find("IgnoreHighlight") != std::string::npos;
        flags.showContentMeta = str_flags.find("ShowContentMeta") != std::string::npos;
        flags.cutSignature = str_flags.find("CutSignature") != std::string::npos;
        flags.outputAsCDATA = str_flags.find("OutputAsCDATA") != std::string::npos;
        flags.xmlStreamerOn = str_flags.find("XmlStreamerOn") != std::string::npos;
        flags.xmlStreamerMobile = str_flags.find("XmlStreamerMobile") != std::string::npos;
        flags.noVdirectLinksWrap = str_flags.find("NoVdirectLinksWrap") != std::string::npos;
        flags.sequentialFactex = str_flags.find("SequentialFactex") != std::string::npos;
        flags.draft = str_flags.find("Draft") != std::string::npos;
        flags.noTrim = str_flags.find("NoTrim") != std::string::npos;
    }

    std::string typesString() const {
        return boost::algorithm::join( types | boost::adaptors::transformed(
                  boost::bind(boost::lexical_cast<std::string,int>,_1)), ",");
    }

    TransformerAttributes()
    {
        flags.ignoreHighlight = false;
        flags.showContentMeta = false;
        flags.cutSignature = false;
        flags.outputAsCDATA = false;
        flags.xmlStreamerOn = false;
        flags.xmlStreamerMobile = false;
        flags.noVdirectLinksWrap = false;
        flags.sequentialFactex = false;
        flags.draft = false;
        flags.noTrim = false;
    }
};


}

