#ifndef BINARY_TRANSFORMER_H_2013_12_12
#define BINARY_TRANSFORMER_H_2013_12_12

#include <internal/fact_extractor/fact_extractor.h>
#include <internal/message_tree.h>
#include <message_body/ext_transformers_selector_result.h>
#include <message_body/binary_transformer_result.h>

namespace msg_body {

class TransformerAttributes;
struct MessageContext;
struct ParserConfig;

class BinaryTransformer {
public:
    BinaryTransformer(const TransformerAttributes& attrs,
                      MessageContext& messageContext,
                      LogPtr logger,
                      const IContentTypeDetector& contentTypeDetector,
                      const AliasClassList& aliasClassList);
    BinaryTransformerResult apply(MessagePart& part) const;

private:
    const TransformerAttributes& attrs_;
    MessageContext& messageContext_;
    LogPtr logger_;
    const IContentTypeDetector& contentTypeDetector_;
    const AliasClassList& aliasClassList_;
};

}

#endif // BINARY_TRANSFORMER_H_2013_12_12
