#pragma once

#include <internal/message_tree.h>
#include <message_body/message_transformer_result.h>
#include <mail_getter/recognizerWrapper.h>

namespace msg_body {

class MessageTransformer {
public:
    MessageTransformer(const IContentTypeDetector& contentTypeDetector, const AliasClassList& aliasClassList,
                       const Recognizer::Wrapper& recognizer);
    MessageTransformerResult apply(MessagePart& part) const;
private:
    const IContentTypeDetector& contentTypeDetector_;
    const AliasClassList& aliasClassList_;
    const Recognizer::Wrapper& recognizer;
};

}
