#pragma once

#include <internal/message_tree.h>
#include <message_body/narod_transformer_result.h>
#include <mail_getter/recognizerWrapper.h>

namespace msg_body {

class TransformerAttributes;

class NarodTransformer {
public:
    NarodTransformer(const TransformerAttributes& attrs,
                     const IContentTypeDetector& contentTypeDetector,
                     const AliasClassList& mimeTypesList,
                     const Recognizer::Wrapper& recognizer);
    NarodTransformerResult apply(MessagePart& part) const;
    TransformNarodAttachResultPtr transformAttach(const std::string& html, const std::string& fakeHid) const;
private:
    const TransformerAttributes& attrs_;
    const IContentTypeDetector& contentTypeDetector_;
    const AliasClassList& mimeTypesList_;
    const Recognizer::Wrapper& recognizer;
};

}
