#pragma once

#include <string>
#include <internal/passbook_parse.h>
#include <internal/logger.h>
#include <mail_getter/recognizerWrapper.h>

namespace msg_body {

struct MessagePart;

class PkpassTransformer {
public:
    PkpassTransformer(const std::string& mid, const std::string& from, LogPtr logger,
                      const Recognizer::Wrapper& recognizer);
    PassbookPackage apply(MessagePart& part) const;
private:
    std::string mid_;
    std::string from_;
    LogPtr logger_;
    const Recognizer::Wrapper* recognizer;
};

}
